//-----------------------------------------------------------------------------
// Simple Text Editor Example for C#Builder
//
// FormEditor.cs
//
// This application is a simple Rich Text Format (RTF) and plain text format
// text editor. It demonstrates:
// 1) Creating Multiple Document Interface (MDI) forms.
// 2) Merging child form menu items with the main form.
// 3) Simple MDI child form arrangement.
// 4) Using RichTextBox, including loading and saving RTF and plain text
//    files, enabling/disabling word wrap, programmatically performing editing
//    operations such as Cut, Copy, Paste and Select All, formatting text
//    including alignment and changing fonts.
//
// By Jarrod Hollingworth
//
//-----------------------------------------------------------------------------
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

namespace TextEditor
{
	/// <summary>
	/// Summary description for WinForm.
	/// </summary>
	public class frmEditor : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.MainMenu mainMenu1;
		private System.Windows.Forms.OpenFileDialog openFileDialog1;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.MenuItem miNew;
		private System.Windows.Forms.MenuItem miOpen;
		private System.Windows.Forms.MenuItem menuItem4;
		private System.Windows.Forms.MenuItem miExit;
		private System.Windows.Forms.MenuItem menuItem6;
		private System.Windows.Forms.MenuItem miTileVertical;
		private System.Windows.Forms.MenuItem miCascade;
		private System.Windows.Forms.MenuItem miArrangeIcons;

    private int DocumentNumber = 0;
    private System.Windows.Forms.MenuItem menuItem10;
    private System.Windows.Forms.MenuItem miWindowList;
    private System.Windows.Forms.MenuItem miTileHorizontal;

		public frmEditor()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
    {
      this.mainMenu1 = new System.Windows.Forms.MainMenu();
      this.menuItem1 = new System.Windows.Forms.MenuItem();
      this.miNew = new System.Windows.Forms.MenuItem();
      this.miOpen = new System.Windows.Forms.MenuItem();
      this.menuItem4 = new System.Windows.Forms.MenuItem();
      this.miExit = new System.Windows.Forms.MenuItem();
      this.menuItem6 = new System.Windows.Forms.MenuItem();
      this.miTileVertical = new System.Windows.Forms.MenuItem();
      this.miTileHorizontal = new System.Windows.Forms.MenuItem();
      this.miCascade = new System.Windows.Forms.MenuItem();
      this.miArrangeIcons = new System.Windows.Forms.MenuItem();
      this.menuItem10 = new System.Windows.Forms.MenuItem();
      this.miWindowList = new System.Windows.Forms.MenuItem();
      this.openFileDialog1 = new System.Windows.Forms.OpenFileDialog();
      // 
      // mainMenu1
      // 
      this.mainMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.menuItem1,
            this.menuItem6});
      // 
      // menuItem1
      // 
      this.menuItem1.Index = 0;
      this.menuItem1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.miNew,
            this.miOpen,
            this.menuItem4,
            this.miExit});
      this.menuItem1.MergeType = System.Windows.Forms.MenuMerge.MergeItems;
      this.menuItem1.Text = "&File";
      // 
      // miNew
      // 
      this.miNew.Index = 0;
      this.miNew.Text = "&New";
      this.miNew.Click += new System.EventHandler(this.miNew_Click);
      // 
      // miOpen
      // 
      this.miOpen.Index = 1;
      this.miOpen.Text = "&Open";
      this.miOpen.Click += new System.EventHandler(this.miOpen_Click);
      // 
      // menuItem4
      // 
      this.menuItem4.Index = 2;
      this.menuItem4.MergeOrder = 100;
      this.menuItem4.Text = "-";
      // 
      // miExit
      // 
      this.miExit.Index = 3;
      this.miExit.MergeOrder = 101;
      this.miExit.Text = "E&xit";
      this.miExit.Click += new System.EventHandler(this.miExit_Click);
      // 
      // menuItem6
      // 
      this.menuItem6.Index = 1;
      this.menuItem6.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.miTileVertical,
            this.miTileHorizontal,
            this.miCascade,
            this.miArrangeIcons,
            this.menuItem10,
            this.miWindowList});
      this.menuItem6.MergeOrder = 10;
      this.menuItem6.Text = "&Window";
      // 
      // miTileVertical
      // 
      this.miTileVertical.Index = 0;
      this.miTileVertical.Text = "Tile &Vertical";
      this.miTileVertical.Click += new System.EventHandler(this.miTileVertical_Click);
      // 
      // miTileHorizontal
      // 
      this.miTileHorizontal.Index = 1;
      this.miTileHorizontal.Text = "Tile &Horizontal";
      this.miTileHorizontal.Click += new System.EventHandler(this.miTileHorizontal_Click);
      //
      // miCascade
      // 
      this.miCascade.Index = 2;
      this.miCascade.Text = "&Cascade";
      this.miCascade.Click += new System.EventHandler(this.miCascade_Click);
      // 
      // miArrangeIcons
      // 
      this.miArrangeIcons.Index = 3;
      this.miArrangeIcons.Text = "&Arrange Icons";
      this.miArrangeIcons.Click += new System.EventHandler(this.miArrangeIcons_Click);
      // 
      // menuItem10
      // 
      this.menuItem10.Index = 4;
      this.menuItem10.Text = "-";
      // 
      // miWindowList
      // 
      this.miWindowList.Index = 5;
      this.miWindowList.MdiList = true;
      this.miWindowList.Text = "Window List";
      // 
      // openFileDialog1
      // 
      this.openFileDialog1.DefaultExt = "*.rtf";
      this.openFileDialog1.Filter = "Rich text files (*.rtf)|*.rtf|Plain text files (*.txt)|*.txt|All f" +  
        "iles (*.*)|*.*";
      // 
      // frmEditor
      // 
      this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
      this.ClientSize = new System.Drawing.Size(632, 426);
      this.IsMdiContainer = true;
      this.Menu = this.mainMenu1;
      this.MinimumSize = new System.Drawing.Size(300, 152);
      this.Name = "frmEditor";
      this.Text = "Simple Text Editor";
    }
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new frmEditor());
		}

		private void miNew_Click(object sender, System.EventArgs e)
		{
      ++DocumentNumber;
      frmDocument Document = new frmDocument("Untitled" + DocumentNumber);
      Document.MdiParent = this;
      Document.Show();
		}

		private void miOpen_Click(object sender, System.EventArgs e)
		{
			if (openFileDialog1.ShowDialog() == DialogResult.OK) {
				frmDocument Document = new frmDocument("");
        Document.MdiParent = this;
        Document.Open(openFileDialog1.FileName);
        Document.Show();
			}
		}

		private void miExit_Click(object sender, System.EventArgs e)
		{
      Close();
		}

    private void miTileVertical_Click(object sender, System.EventArgs e)
    {
      LayoutMdi(MdiLayout.TileVertical);
    }

    private void miTileHorizontal_Click(object sender, System.EventArgs e)
    {
      LayoutMdi(MdiLayout.TileHorizontal);
    }

    private void miCascade_Click(object sender, System.EventArgs e)
    {
      LayoutMdi(MdiLayout.Cascade);
    }

    private void miArrangeIcons_Click(object sender, System.EventArgs e)
    {
      LayoutMdi(MdiLayout.ArrangeIcons);
    }
	}
}
